#include <bits/stdc++.h>
using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(0);

    int n;
    cin >> n;
    vector<long long> a(n);
    for (int i = 0; i < n; ++i) {
        cin >> a[i];
    }

    vector<long long> prefix(n + 1, 0);
    for (int i = 0; i < n; ++i) {
        prefix[i + 1] = prefix[i] + a[i];
    }

    unordered_map<long long, unordered_map<long long, int>> min_count;
    unordered_map<long long, int> current_counts;
    min_count[0] = unordered_map<long long, int>(); // Initialize for prefix sum 0

    int max_freq = 0;

    for (int i = 0; i <= n; ++i) {
        long long s = prefix[i];
        if (i > 0) {
            long long x = a[i - 1];
            current_counts[x]++;

            if (min_count.find(s) != min_count.end()) {
                auto& m = min_count[s];
                if (m.find(x) != m.end()) {
                    int cnt = current_counts[x] - m[x];
                    max_freq = max(max_freq, cnt);
                } else {
                    int cnt = current_counts[x];
                    max_freq = max(max_freq, cnt);
                }
            }
        }

        if (i < n) {
            long long next_s = prefix[i + 1];
            if (min_count.find(next_s) == min_count.end()) {
                min_count[next_s] = unordered_map<long long, int>();
            }
            auto& m = min_count[next_s];
            for (auto& pair : current_counts) {
                long long x = pair.first;
                if (m.find(x) == m.end() || pair.second < m[x]) {
                    m[x] = pair.second;
                }
            }
        }
    }

    cout << max_freq << endl;

    return 0;
}